using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Windows.Forms;

namespace CLB
{
	/// <summary>
	/// Zusammenfassung fr CheckedListBoxEx.
	/// </summary>
	public class CheckedListBoxEx : CheckedListBox
	{
		/// <summary>
		/// Erforderliche Designervariable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		ArrayList list;
		bool enableEvents = true;

		public CheckedListBoxEx()
		{
			// Dieser Aufruf ist fr den Windows Form-Designer erforderlich.
			InitializeComponent();
			base.Sorted = false;
		}

		/// <summary>
		/// Verwendete Ressourcen bereinigen.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if( components != null )
					components.Dispose();
			}
			base.Dispose( disposing );
		}

		#region Vom Komponenten-Designer generierter Code
		/// <summary>
		/// Erforderliche Methode fr die Designeruntersttzung. 
		/// Der Inhalt der Methode darf nicht mit dem Code-Editor gendert werden.
		/// </summary>
		private void InitializeComponent()
		{
			components = new System.ComponentModel.Container();
		}
		#endregion

		protected override void OnItemCheck(ItemCheckEventArgs ice) {
			base.OnItemCheck (ice);
			if (enableEvents) {
				//Console.WriteLine("OnItemCheck");
				SortList();
			}
		}
		protected override void OnDoubleClick(EventArgs e) {
			base.OnDoubleClick (e);
			if (enableEvents) {
				//Console.WriteLine("OnDoubleClick");
				SortList();
			}
		}
		protected override void OnSelectedValueChanged(EventArgs e) {
			base.OnSelectedValueChanged (e);
			if (enableEvents) {
				//Console.WriteLine("OnSelectedValueChanged");
				SortList();
			}
		}
		protected override void OnLayout(LayoutEventArgs levent) {
			base.OnLayout (levent);
			if (enableEvents) {
				//Console.WriteLine("OnLayout");
				SortList();
			}
		}
		public void SortList () {
			if (this.Sorted == false) return;
			enableEvents = false;
			//Console.WriteLine("Sort");
			string selected = "";
			if (this.SelectedItem != null) selected = this.SelectedItem.ToString();
			list = new ArrayList();
			for (int idx = 0; idx < Items.Count; idx++) {
				if (GetItemCheckState(idx) == CheckState.Checked) {
					list.Add(positionChecked.ToString() + Items[idx] + "1");
				} else if (GetItemCheckState(idx) == CheckState.Unchecked) {
					list.Add(positionUnchecked.ToString() + Items[idx] + "0");
				} else {
					list.Add(positionIndeterminate.ToString() + Items[idx] + "2");
				}
			}
			list.Sort();
			this.Items.Clear();
			int selectedIndex = -1;
			int i = 0;
			foreach (string str in list) {
				int len = str.Length;
				string state = str.Substring(len-1,1);
				len -= 2;
				string item = str.Substring(1,len);
				if (state == "0") {
					this.Items.Add(item,CheckState.Unchecked);
				} else if (state == "1") {
					this.Items.Add(item,CheckState.Checked);
				} else {
					this.Items.Add(item,CheckState.Indeterminate);
				}
				if (selectedIndex == -1 & item == selected) selectedIndex = i;
				i++;
			}
			if (selectedIndex != -1) this.SelectedIndex = selectedIndex;
			enableEvents = true;
		}

		new public void BeginUpdate() {
			base.BeginUpdate();
			enableEvents = false;
		}
		new public void EndUpdate() {
			base.EndUpdate();
			SortList();
			enableEvents = true;
		}

		private int positionChecked = 0;
		public int PositionChecked {
			set {
				if (value < 0 | value > 2) value = 0; 
				positionChecked = value;
				SortList();
			}
			get {return positionChecked;}
		}
		private int positionUnchecked = 0;
		public int PositionUnchecked {
			set {
				if (value < 0 | value > 2) value = 0; 
				positionUnchecked = value;
				SortList();
			}
			get {return positionUnchecked;}
		}
		private int positionIndeterminate = 0;
		public int PositionIndeterminate {
			set {
				if (value < 0 | value > 2) value = 0; 
				positionIndeterminate = value;
				SortList();
			}
			get {return positionIndeterminate;}
		}
		private bool localSorted = false;
		new public bool Sorted {
			set {
				localSorted = value;
				SortList();
			}
			get {return localSorted;}
		}

	}
}
